/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class KryoFluxDisk {
    static final byte[] diskInfo = new byte[]{77, 86, 32, 45, 32, 67, 80, 67, 69, 77, 85, 32, 68, 105, 115, 107, 45, 70, 105, 108, 101, 13, 10, 68, 105, 115, 107, 45, 73, 110, 102, 111, 13, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 1, 0, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] trackInfo = new byte[]{84, 114, 97, 99, 107, 45, 73, 110, 102, 111, 13, 10, 0, 0, 0, 0, 0, 0, 0, 0, 2, 9, 78, -27, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] SectorPos = new int[]{1, 6, 2, 7, 3, 8, 4, 9, 5};

    public static void DskToI4(byte[] data, String filename) {
        byte[] out = new byte[368640];
        int numberOfTracks = data[48] & 0xFF;
        int numberOfSides = data[49] & 0xFF;
        byte[] trackSizes = new byte[256];
        System.arraycopy(data, 52, trackSizes, 0, numberOfTracks * numberOfSides);
        int offset = 512;
        int dskpos = 0;
        for (int track = 0; track < numberOfTracks; ++track) {
            for (int side = 0; side < numberOfSides; ++side) {
                try {
                    int g;
                    int trackLength = (trackSizes[track * numberOfSides + side] & 0xFF) * 256 - 256;
                    byte[] buffer = new byte[trackLength];
                    System.arraycopy(data, offset, buffer, 0, trackLength);
                    byte[][] bufsec = new byte[9][trackLength / 9];
                    for (g = 0; g < 9; ++g) {
                        System.arraycopy(buffer, g * trackLength / 9, bufsec[SectorPos[g] - 1], 0, bufsec[g].length);
                    }
                    for (g = 0; g < 9; ++g) {
                        System.arraycopy(bufsec[g], 0, buffer, g * trackLength / 9, bufsec[g].length);
                    }
                    System.arraycopy(buffer, 0, out, dskpos, buffer.length);
                    dskpos += trackLength;
                    offset += trackLength + 256;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!(filename = filename.replace(".dsk", ".mfm")).endsWith(".mfm")) {
            filename = filename + ".mfm";
        }
        File file = new File(filename);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(out);
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void i4ToDsk(byte[] in, byte[] out, boolean dataMode) {
        int TRACK_COUNT = 40;
        int SECTOR_COUNT = 9;
        int TRACK_SIZE = 4608;
        int inPos = 0;
        int outPos = 0;
        System.arraycopy(diskInfo, 0, out, outPos, 256);
        out[outPos + 48] = 40;
        out[outPos + 49] = 1;
        out[outPos + 50] = 0;
        out[outPos + 51] = 19;
        outPos += 256;
        for (int track = 0; track < 40; ++track) {
            System.arraycopy(trackInfo, 0, out, outPos, 256);
            out[outPos + 16] = (byte)track;
            out[outPos + 17] = 0;
            out[outPos + 20] = 2;
            out[outPos + 21] = 9;
            out[outPos + 22] = 78;
            out[outPos + 23] = -27;
            int sectorInfoPos = outPos + 24;
            for (int sector = 0; sector < 9; ++sector) {
                out[sectorInfoPos + 0] = (byte)track;
                out[sectorInfoPos + 1] = 0;
                out[sectorInfoPos + 2] = (byte)(dataMode ? sector + 193 : sector + 65);
                out[sectorInfoPos + 3] = 2;
                sectorInfoPos += 8;
            }
            System.arraycopy(in, inPos, out, outPos += 256, 4608);
            inPos += 4608;
            outPos += 4608;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.exit(5);
        }
        boolean dataMode = true;
        ArrayList<File> files = new ArrayList<File>(args.length);
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (arg.equals("-s")) {
                    dataMode = false;
                    continue;
                }
                if (!arg.equals("-d")) continue;
                dataMode = true;
                continue;
            }
            File file = new File(arg);
            if (!(file.exists() && file.isFile() && file.canRead())) {
                KryoFluxDisk.exit("[" + arg + "] is not a valid input file");
            }
            files.add(file);
        }
        for (File inFile : files) {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            try {
                fis = new FileInputStream(inFile);
                bis = new BufferedInputStream(fis);
                long inFileSize = fis.getChannel().size();
                byte[] inFileData = new byte[(int)inFileSize];
                bis.read(inFileData);
                byte[] outFileData = new byte[194816];
                KryoFluxDisk.i4ToDsk(inFileData, outFileData, dataMode);
                String outFileName = inFile.getName().replaceAll("\\.[^\\.]+$", ".dsk");
                if (!outFileName.endsWith(".dsk")) {
                    outFileName = outFileName + ".dsk";
                }
                File outFile = new File(outFileName);
                fos = new FileOutputStream(outFile);
                fos.write(outFileData);
                fos.flush();
            }
            catch (FileNotFoundException e) {
                KryoFluxDisk.exit("FileNotFoundException: " + e.getMessage());
            }
            catch (IOException e) {
                KryoFluxDisk.exit("IOException: " + e.getMessage());
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception e) {
                    }
                    finally {
                        bis = null;
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                    }
                    finally {
                        bis = null;
                    }
                }
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (Exception e) {}
                continue;
                finally {
                    fos = null;
                }
            }
        }
    }

    private static void exit(String msg) {
        System.err.println(msg);
        System.exit(5);
    }
}

